﻿function Add-SCBaselineUpdates
{
    param
    (
        [Parameter(Mandatory=$true, HelpMessage='VMM Server')]
        [String]
        $VMMServer,
        [Parameter(Mandatory=$false, HelpMessage='Filtering for Updates. i.e. Windows Server 2012 R2')]
        [String]
        $Filter='Windows Server 2012 R2'
    )

    $Baseline=Get-SCBaseline -VMMServer $VMMServer|Out-GridView -PassThru -Title "VMM Update Baselines"
    $UpdateServer=Get-SCUpdateServer -VMMServer $VMMServer|Out-GridView -PassThru -Title "VMM Update Server"
    Start-SCUpdateServerSynchronization -VMMServer $VMMServer -UpdateServer $UpdateServer
    $Updates=Get-SCUpdate -VMMServer $VMMServer|Where-Object {$_.Name -like "*$Filter*"}
    $BaselineUpdates=$Baseline.Updates|Where-Object {$_.Name -like "*$Filter*"}
    $NewUpdates=$Updates
    foreach($Update in $Updates)
    {
        foreach($BaselineUpdate in $BaselineUpdates)
        {
            if($Update.ID -eq $BaselineUpdate.ID){
                $NewUpdates=$NewUpdates|Where-Object {$_.ID -ne $Update.ID}
            }
        }
    }
    $AddUpdates=$NewUpdates|Out-GridView -PassThru -Title "New Updates"
    Set-SCBaseline -VMMServer $VMMServer -Baseline $Baseline -AddUpdates $AddUpdates
}